/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.retrieve;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.retrieve.EndRetrieveArtifactEvent;
import org.apache.ivy.core.event.retrieve.EndRetrieveEvent;
import org.apache.ivy.core.event.retrieve.StartRetrieveArtifactEvent;
import org.apache.ivy.core.event.retrieve.StartRetrieveEvent;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.retrieve.RetrieveReport;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class RetrieveEngine {
    private RetrieveEngineSettings settings;
    private EventManager eventManager;

    public RetrieveEngine(RetrieveEngineSettings retrieveEngineSettings, EventManager eventManager) {
        this.settings = retrieveEngineSettings;
        this.eventManager = eventManager;
    }

    public RetrieveReport retrieve(ModuleRevisionId moduleRevisionId, RetrieveOptions retrieveOptions) throws IOException {
        RetrieveReport retrieveReport = new RetrieveReport();
        ModuleId moduleId = moduleRevisionId.getModuleId();
        if ("default".equals(retrieveOptions.getLog())) {
            Message.info(":: retrieving :: " + moduleId + (retrieveOptions.isSync() ? " [sync]" : ""));
        } else {
            Message.verbose(":: retrieving :: " + moduleId + (retrieveOptions.isSync() ? " [sync]" : ""));
        }
        Message.verbose("\tcheckUpToDate=" + this.settings.isCheckUpToDate());
        long l = System.currentTimeMillis();
        Object object = IvyPatternHelper.substituteVariables(retrieveOptions.getDestArtifactPattern(), this.settings.getVariables());
        String string = IvyPatternHelper.substituteVariables(retrieveOptions.getDestIvyPattern(), this.settings.getVariables());
        String[] stringArray = this.getConfs(moduleRevisionId, retrieveOptions);
        if ("default".equals(retrieveOptions.getLog())) {
            Message.info("\tconfs: " + Arrays.asList(stringArray));
        } else {
            Message.verbose("\tconfs: " + Arrays.asList(stringArray));
        }
        if (this.eventManager != null) {
            this.eventManager.fireIvyEvent(new StartRetrieveEvent(moduleRevisionId, stringArray, retrieveOptions));
        }
        try {
            Object object2;
            Object object3;
            Set set;
            Object object4;
            Map map = this.determineArtifactsToCopy(moduleRevisionId, (String)object, retrieveOptions);
            object = this.settings.resolveFile(IvyPatternHelper.getTokenRoot((String)object));
            retrieveReport.setRetrieveRoot((File)object);
            string = string == null ? null : this.settings.resolveFile(IvyPatternHelper.getTokenRoot(string));
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            long l2 = 0L;
            for (Object object5 : map.keySet()) {
                object4 = ((ArtifactDownloadReport)object5).getLocalFile();
                if (object4 == null) {
                    Message.verbose("\tno local file available for " + object5 + ": skipping");
                    continue;
                }
                set = (Set)map.get(object5);
                Message.verbose("\tretrieving " + object4);
                object3 = set.iterator();
                while (object3.hasNext()) {
                    IvyContext.getContext().checkInterrupted();
                    object2 = this.settings.resolveFile((String)object3.next());
                    if (!this.settings.isCheckUpToDate() || !this.upToDate((File)object4, (File)object2, retrieveOptions)) {
                        Message.verbose("\t\tto " + object2);
                        if (this.eventManager != null) {
                            this.eventManager.fireIvyEvent(new StartRetrieveArtifactEvent((ArtifactDownloadReport)object5, (File)object2));
                        }
                        if (retrieveOptions.isMakeSymlinks()) {
                            FileUtil.symlink((File)object4, (File)object2, null, true);
                        } else {
                            FileUtil.copy((File)object4, (File)object2, null, true);
                        }
                        if (this.eventManager != null) {
                            this.eventManager.fireIvyEvent(new EndRetrieveArtifactEvent((ArtifactDownloadReport)object5, (File)object2));
                        }
                        l2 += ((File)object2).length();
                        retrieveReport.addCopiedFile((File)object2, (ArtifactDownloadReport)object5);
                    } else {
                        Message.verbose("\t\tto " + object2 + " [NOT REQUIRED]");
                        retrieveReport.addUpToDateFile((File)object2, (ArtifactDownloadReport)object5);
                    }
                    if ("ivy".equals(((ArtifactDownloadReport)object5).getType())) {
                        hashSet2.addAll(FileUtil.getPathFiles((File)((Object)string), (File)object2));
                        continue;
                    }
                    hashSet.addAll(FileUtil.getPathFiles((File)object, (File)object2));
                }
            }
            if (retrieveOptions.isSync()) {
                Object object5;
                Message.verbose("\tsyncing...");
                String[] stringArray2 = this.settings.getIgnorableFilenames();
                object5 = Arrays.asList(stringArray2);
                object4 = FileUtil.listAll((File)object, (Collection)object5);
                Collection collection = set = string == null ? null : FileUtil.listAll((File)((Object)string), (Collection)object5);
                if (((File)object).equals(string)) {
                    object3 = hashSet;
                    object3.addAll(hashSet2);
                    object2 = object4;
                    object2.addAll(set);
                    this.sync((Collection)object3, (Collection)object2);
                } else {
                    this.sync(hashSet, (Collection)object4);
                    if (set != null) {
                        this.sync(hashSet2, set);
                    }
                }
            }
            long l3 = System.currentTimeMillis() - l;
            object4 = "\t" + retrieveReport.getNbrArtifactsCopied() + " artifacts copied" + (this.settings.isCheckUpToDate() ? ", " + retrieveReport.getNbrArtifactsUpToDate() + " already retrieved" : "") + " (" + l2 / 1024L + "kB/" + l3 + "ms)";
            if ("default".equals(retrieveOptions.getLog())) {
                Message.info((String)object4);
            } else {
                Message.verbose((String)object4);
            }
            Message.verbose("\tretrieve done (" + l3 + "ms)");
            if (this.eventManager != null) {
                this.eventManager.fireIvyEvent(new EndRetrieveEvent(moduleRevisionId, stringArray, l3, retrieveReport.getNbrArtifactsCopied(), retrieveReport.getNbrArtifactsUpToDate(), l2, retrieveOptions));
            }
            return retrieveReport;
        }
        catch (Exception exception) {
            throw new RuntimeException("problem during retrieve of " + moduleId + ": " + exception, exception);
        }
    }

    private String[] getConfs(ModuleRevisionId object, RetrieveOptions object2) throws IOException {
        String[] stringArray = ((RetrieveOptions)object2).getConfs();
        if (stringArray == null || stringArray.length == 1 && "*".equals(stringArray[0])) {
            try {
                object = this.getCache().getResolvedModuleDescriptor((ModuleRevisionId)object);
                Message.verbose("no explicit confs given for retrieve, using ivy file: " + object.getResource().getName());
                stringArray = object.getConfigurationsNames();
                ((RetrieveOptions)object2).setConfs(stringArray);
            }
            catch (IOException iOException) {
                object = iOException;
                throw iOException;
            }
            catch (Exception exception) {
                object2 = new IOException(exception.getMessage());
                ((Throwable)object2).initCause(exception);
                throw object2;
            }
        }
        return stringArray;
    }

    private ResolutionCacheManager getCache() {
        return this.settings.getResolutionCacheManager();
    }

    private void sync(Collection collection, Collection iterator) {
        HashSet<File> hashSet = new HashSet<File>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            hashSet.add(file.getAbsoluteFile());
        }
        for (File file : collection) {
            hashSet.remove(file.getAbsoluteFile());
        }
        for (File file : hashSet) {
            if (!file.exists()) continue;
            Message.verbose("\t\tdeleting " + file);
            FileUtil.forceDelete(file);
        }
    }

    public Map determineArtifactsToCopy(ModuleRevisionId stringArray, String string, RetrieveOptions retrieveOptions) throws ParseException, IOException {
        Object object;
        String[] stringArray2;
        Object object2;
        Object object3;
        Object object4 = stringArray.getModuleId();
        if (retrieveOptions.getResolveId() == null) {
            retrieveOptions.setResolveId(ResolveOptions.getDefaultResolveId((ModuleId)object4));
        }
        object4 = this.getCache();
        stringArray = this.getConfs((ModuleRevisionId)stringArray, retrieveOptions);
        String[] stringArray3 = IvyPatternHelper.substituteVariables(retrieveOptions.getDestIvyPattern(), this.settings.getVariables());
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        XmlReportParser xmlReportParser = new XmlReportParser();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            object3 = object4.getConfigurationResolveReportInCache(retrieveOptions.getResolveId(), string2);
            xmlReportParser.parse((File)object3);
            object2 = new ArrayList<ArtifactDownloadReport>(Arrays.asList(xmlReportParser.getArtifactReports()));
            if (stringArray3 != null) {
                object3 = xmlReportParser.getRealDependencyRevisionIds();
                for (int j = 0; j < ((Object)object3).length; ++j) {
                    object2.add((ArtifactDownloadReport)xmlReportParser.getMetadataArtifactReport((ModuleRevisionId)object3[j]));
                }
            }
            object3 = object2.iterator();
            while (object3.hasNext()) {
                ArtifactDownloadReport artifactDownloadReport = (ArtifactDownloadReport)object3.next();
                String[] stringArray4 = stringArray2 = "ivy".equals(artifactDownloadReport.getType()) ? stringArray3 : string;
                if (!"ivy".equals(artifactDownloadReport.getType()) && !retrieveOptions.getArtifactFilter().accept(artifactDownloadReport.getArtifact())) continue;
                HashSet<ArtifactRevisionId> hashSet = IvyPatternHelper.substitute((String)stringArray2, artifactDownloadReport.getArtifact().getModuleRevisionId(), artifactDownloadReport.getArtifact(), string2, artifactDownloadReport.getArtifactOrigin());
                object = (Set)hashMap.get(artifactDownloadReport);
                if (object == null) {
                    object = new HashSet<String>();
                    hashMap.put(artifactDownloadReport, object);
                }
                object2 = this.settings.resolveFile((String)((Object)hashSet)).getAbsolutePath();
                stringArray2 = new String[]{object2};
                if (retrieveOptions.getMapper() != null) {
                    stringArray2 = retrieveOptions.getMapper().mapFileName((String)object2);
                }
                for (int j = 0; j < stringArray2.length; ++j) {
                    object.add(stringArray2[j]);
                    hashSet = (Set)hashMap2.get(stringArray2[j]);
                    HashSet<ArtifactDownloadReport> hashSet2 = (HashSet<ArtifactDownloadReport>)hashMap3.get(stringArray2[j]);
                    HashSet<String> hashSet3 = (HashSet<String>)hashMap4.get(stringArray2[j]);
                    if (hashSet == null) {
                        hashSet = new HashSet<ArtifactRevisionId>();
                        hashMap2.put(stringArray2[j], hashSet);
                    }
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<ArtifactDownloadReport>();
                        hashMap3.put(stringArray2[j], hashSet2);
                    }
                    if (hashSet3 == null) {
                        hashSet3 = new HashSet<String>();
                        hashMap4.put(stringArray2[j], hashSet3);
                    }
                    if (!hashSet.add(artifactDownloadReport.getArtifact().getId())) continue;
                    hashSet2.add(artifactDownloadReport);
                    hashSet3.add(string2);
                }
            }
        }
        for (String string2 : hashMap2.keySet()) {
            int n;
            object3 = (Set)hashMap2.get(string2);
            object2 = (Set)hashMap4.get(string2);
            if (object3.size() <= 1) continue;
            object3 = new ArrayList((Collection)hashMap3.get(string2));
            Collections.sort(object3, this.getConflictResolvingPolicy());
            Object object5 = object3;
            ArtifactDownloadReport artifactDownloadReport = (ArtifactDownloadReport)object5.get(object5.size() - 1);
            stringArray2 = artifactDownloadReport.getArtifact().getModuleRevisionId();
            for (n = object3.size() - 2; n >= 0; --n) {
                object = (ArtifactDownloadReport)object3.get(n);
                if (!stringArray2.equals(((ArtifactDownloadReport)object).getArtifact().getModuleRevisionId())) continue;
                throw new RuntimeException("Multiple artifacts of the module " + stringArray2 + " are retrieved to the same file! Update the retrieve pattern  to fix this error.");
            }
            Message.info("\tconflict on " + string2 + " in " + object2 + ": " + stringArray2.getRevision() + " won");
            for (n = object3.size() - 2; n >= 0; --n) {
                object = (ArtifactDownloadReport)object3.get(n);
                Message.verbose("\t\tremoving conflict looser artifact: " + ((ArtifactDownloadReport)object).getArtifact());
                object2 = (Set)hashMap.get(object);
                object2.remove(string2);
                if (!object2.isEmpty()) continue;
                hashMap.remove(object);
            }
        }
        return hashMap;
    }

    private boolean upToDate(File file, File file2, RetrieveOptions object) {
        if (!file2.exists()) {
            return false;
        }
        if ("always".equals(object = ((RetrieveOptions)object).getOverwriteMode())) {
            return false;
        }
        if ("never".equals(object)) {
            return true;
        }
        if ("newer".equals(object)) {
            return file.lastModified() <= file2.lastModified();
        }
        if ("different".equals(object)) {
            return file.lastModified() == file2.lastModified();
        }
        return false;
    }

    private Comparator getConflictResolvingPolicy() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                object = ((ArtifactDownloadReport)object).getArtifact();
                object2 = ((ArtifactDownloadReport)object2).getArtifact();
                if (object.getPublicationDate().after(object2.getPublicationDate())) {
                    return 1;
                }
                if (object.getPublicationDate().before(object2.getPublicationDate())) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

