/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.download.PrepareDownloadEvent;
import org.apache.ivy.core.event.resolve.EndResolveEvent;
import org.apache.ivy.core.event.resolve.StartResolveEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.RestartResolveProcess;
import org.apache.ivy.core.resolve.VisitNode;
import org.apache.ivy.core.sort.SortEngine;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;

public class ResolveEngine {
    private ResolveEngineSettings settings;
    private EventManager eventManager;
    private SortEngine sortEngine;
    private Set fetchedSet = new HashSet();
    private DependencyResolver dictatorResolver;

    public ResolveEngine(ResolveEngineSettings resolveEngineSettings, EventManager eventManager, SortEngine sortEngine) {
        this.settings = resolveEngineSettings;
        this.eventManager = eventManager;
        this.sortEngine = sortEngine;
    }

    public DependencyResolver getDictatorResolver() {
        return this.dictatorResolver;
    }

    public void setDictatorResolver(DependencyResolver dependencyResolver) {
        this.dictatorResolver = dependencyResolver;
        this.settings.setDictatorResolver(dependencyResolver);
    }

    public ResolveReport resolve(ModuleDescriptor moduleDescriptor, ResolveOptions resolveOptions) throws ParseException, IOException {
        DependencyResolver dependencyResolver = this.getDictatorResolver();
        IvyContext ivyContext = IvyContext.getContext();
        try {
            Object object;
            Object object2;
            String[] stringArray = resolveOptions.getConfs(moduleDescriptor);
            resolveOptions.setConfs(stringArray);
            if (resolveOptions.getResolveId() == null) {
                resolveOptions.setResolveId(ResolveOptions.getDefaultResolveId(moduleDescriptor));
            }
            this.eventManager.fireIvyEvent(new StartResolveEvent(moduleDescriptor, stringArray));
            long l = System.currentTimeMillis();
            if ("default".equals(resolveOptions.getLog())) {
                Message.info(":: resolving dependencies :: " + moduleDescriptor.getResolvedModuleRevisionId() + (resolveOptions.isTransitive() ? "" : " [not transitive]"));
                Message.info("\tconfs: " + Arrays.asList(stringArray));
            } else {
                Message.verbose(":: resolving dependencies :: " + moduleDescriptor.getResolvedModuleRevisionId() + (resolveOptions.isTransitive() ? "" : " [not transitive]"));
                Message.verbose("\tconfs: " + Arrays.asList(stringArray));
            }
            Message.verbose("\tvalidate = " + resolveOptions.isValidate());
            Message.verbose("\trefresh = " + resolveOptions.isRefresh());
            ResolveReport resolveReport = new ResolveReport(moduleDescriptor, resolveOptions.getResolveId());
            IvyNode[] ivyNodeArray = new ResolveData(this, resolveOptions);
            ivyContext.setResolveData((ResolveData)ivyNodeArray);
            ivyNodeArray = this.getDependencies(moduleDescriptor, resolveOptions, resolveReport);
            resolveReport.setDependencies(Arrays.asList(ivyNodeArray), resolveOptions.getArtifactFilter());
            if (resolveOptions.getCheckIfChanged()) {
                resolveReport.checkIfChanged();
            }
            ResolutionCacheManager resolutionCacheManager = this.settings.getResolutionCacheManager();
            resolutionCacheManager.saveResolvedModuleDescriptor(moduleDescriptor);
            File file = resolutionCacheManager.getResolvedIvyPropertiesInCache(moduleDescriptor.getResolvedModuleRevisionId());
            Properties properties = new Properties();
            if (ivyNodeArray.length > 0) {
                Object object3;
                Object object4;
                int n;
                object2 = new HashMap();
                for (int i = 0; i < ivyNodeArray.length; ++i) {
                    if (ivyNodeArray[i].getModuleRevision() == null || !ivyNodeArray[i].getModuleRevision().isForce()) continue;
                    object2.put(ivyNodeArray[i].getModuleId(), ivyNodeArray[i].getResolvedId());
                }
                object = ivyNodeArray[0].getRoot();
                HashMap<ModuleId, IvyNode> hashMap = new HashMap<ModuleId, IvyNode>();
                for (n = 0; n < ivyNodeArray.length; ++n) {
                    if (ivyNodeArray[n].hasProblem() || (object4 = ivyNodeArray[n].getDependencyDescriptor((IvyNode)object)) == null) continue;
                    object3 = ivyNodeArray[n].getModuleId();
                    hashMap.put((ModuleId)object3, ivyNodeArray[n]);
                }
                for (n = 0; n < ivyNodeArray.length; ++n) {
                    Object object5;
                    if (ivyNodeArray[n].hasProblem() || ivyNodeArray[n].isCompletelyEvicted()) continue;
                    object4 = ivyNodeArray[n].getDependencyDescriptor((IvyNode)object);
                    if (object4 == null && (object5 = (IvyNode)hashMap.get(object3 = ivyNodeArray[n].getModuleId())) != null) {
                        object4 = ((IvyNode)object5).getDependencyDescriptor((IvyNode)object);
                    }
                    if (object4 == null) continue;
                    object3 = ivyNodeArray[n].getResolvedId();
                    object5 = ivyNodeArray[n].getDescriptor();
                    ModuleRevisionId moduleRevisionId = object4.getDependencyRevisionId();
                    Object object6 = (ModuleRevisionId)object2.get(ivyNodeArray[n].getModuleId());
                    if (ivyNodeArray[n].getModuleRevision() != null && ivyNodeArray[n].getModuleRevision().isForce() && !((ModuleRevisionId)object3).equals(moduleRevisionId) && !this.settings.getVersionMatcher().isDynamic(moduleRevisionId)) {
                        object3 = moduleRevisionId;
                        object5 = null;
                    }
                    if (object3 == null) {
                        throw new NullPointerException("getResolvedId() is null for " + ivyNodeArray[n].toString());
                    }
                    if (moduleRevisionId == null) {
                        throw new NullPointerException("getDependencyRevisionId() is null for " + object4.toString());
                    }
                    object4 = ((ModuleRevisionId)object3).getRevision();
                    object6 = object6 == null ? object4 : ((ModuleRevisionId)object6).getRevision();
                    object5 = object5 == null ? "?" : object5.getStatus();
                    Message.debug("storing dependency " + object3 + " in props");
                    properties.put(moduleRevisionId.encodeToString(), (String)object4 + " " + (String)object5 + " " + (String)object6 + " " + ((ModuleRevisionId)object3).getBranch());
                }
            }
            object2 = new FileOutputStream(file);
            properties.store((OutputStream)object2, moduleDescriptor.getResolvedModuleRevisionId() + " resolved revisions");
            ((FileOutputStream)object2).close();
            Message.verbose("\tresolved ivy file produced in cache");
            resolveReport.setResolveTime(System.currentTimeMillis() - l);
            if (resolveOptions.isDownload()) {
                Message.verbose(":: downloading artifacts ::");
                this.downloadArtifacts(resolveReport, resolveOptions.getArtifactFilter(), (DownloadOptions)new DownloadOptions().setLog(resolveOptions.getLog()));
            }
            if (resolveOptions.isOutputReport()) {
                this.outputReport(resolveReport, resolutionCacheManager, resolveOptions);
            }
            Message.verbose("\tresolve done (" + resolveReport.getResolveTime() + "ms resolve - " + resolveReport.getDownloadTime() + "ms download)");
            Message.sumupProblems();
            this.eventManager.fireIvyEvent(new EndResolveEvent(moduleDescriptor, stringArray, resolveReport));
            object = resolveReport;
            return object;
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            Message.error(runtimeException.getMessage());
            Message.sumupProblems();
            throw runtimeException2;
        }
        finally {
            ivyContext.setResolveData(null);
            this.setDictatorResolver(dependencyResolver);
        }
    }

    public void outputReport(ResolveReport resolveReport, ResolutionCacheManager resolutionCacheManager, ResolveOptions resolveOptions) throws IOException {
        if ("default".equals(resolveOptions.getLog())) {
            Message.info(":: resolution report :: resolve " + resolveReport.getResolveTime() + "ms :: artifacts dl " + resolveReport.getDownloadTime() + "ms");
        } else {
            Message.verbose(":: resolution report :: resolve " + resolveReport.getResolveTime() + "ms :: artifacts dl " + resolveReport.getDownloadTime() + "ms");
        }
        resolveReport.setProblemMessages(Message.getProblems());
        resolveReport.output(this.settings.getReportOutputters(), resolutionCacheManager, resolveOptions);
    }

    public void downloadArtifacts(ResolveReport resolveReport, Filter filter, DownloadOptions downloadOptions) {
        long l = System.currentTimeMillis();
        IvyNode[] ivyNodeArray = resolveReport.getDependencies().toArray(new IvyNode[resolveReport.getDependencies().size()]);
        this.eventManager.fireIvyEvent(new PrepareDownloadEvent(resolveReport.getArtifacts().toArray(new Artifact[resolveReport.getArtifacts().size()])));
        long l2 = 0L;
        for (int i = 0; i < ivyNodeArray.length; ++i) {
            this.checkInterrupted();
            if (ivyNodeArray[i].isCompletelyEvicted() || ivyNodeArray[i].hasProblem() || ivyNodeArray[i].getModuleRevision() == null) continue;
            DependencyResolver dependencyResolver = ivyNodeArray[i].getModuleRevision().getArtifactResolver();
            Object object = ivyNodeArray[i].getSelectedArtifacts(filter);
            object = dependencyResolver.download((Artifact[])object, downloadOptions);
            ArtifactDownloadReport[] artifactDownloadReportArray = object.getArtifactsReports();
            for (int j = 0; j < artifactDownloadReportArray.length; ++j) {
                if (artifactDownloadReportArray[j].getDownloadStatus() == DownloadStatus.FAILED) {
                    if (artifactDownloadReportArray[j].getArtifact().getExtraAttribute("ivy:merged") != null) {
                        Message.warn("\tmerged artifact not found: " + artifactDownloadReportArray[j].getArtifact() + ". It was required in " + artifactDownloadReportArray[j].getArtifact().getExtraAttribute("ivy:merged"));
                        continue;
                    }
                    Message.warn("\t" + artifactDownloadReportArray[j]);
                    dependencyResolver.reportFailure(artifactDownloadReportArray[j].getArtifact());
                    continue;
                }
                if (artifactDownloadReportArray[j].getDownloadStatus() != DownloadStatus.SUCCESSFUL) continue;
                l2 += artifactDownloadReportArray[j].getSize();
            }
            String[] stringArray = ivyNodeArray[i].getRootModuleConfigurations();
            for (int j = 0; j < stringArray.length; ++j) {
                if (ivyNodeArray[i].isEvicted(stringArray[j]) || ivyNodeArray[i].isBlacklisted(stringArray[j])) {
                    resolveReport.getConfigurationReport(stringArray[j]).addDependency(ivyNodeArray[i]);
                    continue;
                }
                resolveReport.getConfigurationReport(stringArray[j]).addDependency(ivyNodeArray[i], (DownloadReport)object);
            }
        }
        resolveReport.setDownloadTime(System.currentTimeMillis() - l);
        resolveReport.setDownloadSize(l2);
    }

    public IvyNode[] getDependencies(ModuleDescriptor moduleDescriptor, ResolveOptions resolveOptions, ResolveReport resolveReport) {
        if (moduleDescriptor == null) {
            throw new NullPointerException("module descriptor must not be null");
        }
        String[] stringArray = resolveOptions.getConfs(moduleDescriptor);
        Cloneable cloneable = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new NullPointerException("null conf not allowed: confs where: " + Arrays.asList(stringArray));
            }
            if (moduleDescriptor.getConfiguration(stringArray[i]) != null) continue;
            cloneable.add(" '" + stringArray[i] + "' ");
        }
        if (!cloneable.isEmpty()) {
            throw new IllegalArgumentException("requested configuration" + (cloneable.size() > 1 ? "s" : "") + " not found in " + moduleDescriptor.getModuleRevisionId() + ": " + cloneable);
        }
        Object object = IvyContext.pushNewCopyContext();
        try {
            Object object22;
            Iterator<IvyNode> iterator;
            resolveOptions.setConfs(stringArray);
            cloneable = new Date();
            ResolveData resolveData = ((IvyContext)object).getResolveData();
            if (resolveData == null) {
                resolveData = new ResolveData(this, resolveOptions);
                ((IvyContext)object).setResolveData(resolveData);
            }
            object = new IvyNode(resolveData, moduleDescriptor);
            for (int i = 0; i < stringArray.length; ++i) {
                Message.verbose("resolving dependencies for configuration '" + stringArray[i] + "'");
                this.fetchedSet.clear();
                iterator = null;
                if (resolveReport != null && (iterator = resolveReport.getConfigurationReport(stringArray[i])) == null) {
                    iterator = new ConfigurationResolveReport(this, moduleDescriptor, stringArray[i], (Date)cloneable, resolveOptions);
                    resolveReport.addReport(stringArray[i], (ConfigurationResolveReport)((Object)iterator));
                }
                resolveData.setReport((ConfigurationResolveReport)((Object)iterator));
                object22 = new VisitNode(resolveData, (IvyNode)object, null, stringArray[i], null);
                ((VisitNode)object22).setRequestedConf(stringArray[i]);
                ((IvyNode)object).updateConfsToFetch(Collections.singleton(stringArray[i]));
                boolean bl = false;
                while (!bl) {
                    try {
                        this.fetchDependencies((VisitNode)object22, stringArray[i], false);
                        bl = true;
                    }
                    catch (RestartResolveProcess restartResolveProcess) {
                        Message.verbose("====================================================");
                        Message.verbose("=           RESTARTING RESOLVE PROCESS");
                        Message.verbose("= " + restartResolveProcess.getMessage());
                        Message.verbose("====================================================");
                        this.fetchedSet.clear();
                    }
                }
                for (Object object22 : resolveData.getNodes()) {
                    ((IvyNode)object22).clean();
                }
            }
            Collection collection = resolveData.getNodes();
            iterator = new LinkedHashSet(collection.size());
            for (IvyNode ivyNode : collection) {
                if (ivyNode == null || ivyNode.isRoot() || ivyNode.isCompletelyBlacklisted()) continue;
                iterator.add(ivyNode);
            }
            object22 = this.sortEngine.sortNodes((Collection)((Object)iterator), SortOptions.SILENT);
            Collections.reverse(object22);
            this.handleTransiviteEviction(moduleDescriptor, stringArray, resolveData, (List)object22);
            Iterator<IvyNode> iterator2 = iterator;
            IvyNode[] ivyNodeArray = iterator2.toArray(new IvyNode[iterator2.size()]);
            return ivyNodeArray;
        }
        finally {
            IvyContext.popContext();
        }
    }

    private void handleTransiviteEviction(ModuleDescriptor moduleDescriptor, String[] stringArray, ResolveData resolveData, List object) {
        object = object.listIterator();
        while (object.hasNext()) {
            IvyNode ivyNode = (IvyNode)object.next();
            if (ivyNode.isCompletelyEvicted()) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                IvyNodeCallers.Caller[] callerArray = ivyNode.getCallers(stringArray[i]);
                if (this.settings.debugConflictResolution()) {
                    Message.debug("checking if " + ivyNode.getId() + " is transitively evicted in " + stringArray[i]);
                }
                boolean bl = callerArray.length > 0;
                for (int j = 0; j < callerArray.length; ++j) {
                    if (callerArray[j].getModuleRevisionId().equals(moduleDescriptor.getModuleRevisionId())) {
                        bl = false;
                        break;
                    }
                    IvyNode ivyNode2 = resolveData.getNode(callerArray[j].getModuleRevisionId());
                    if (ivyNode2 == null) {
                        Message.warn("ivy internal error: no node found for " + callerArray[j].getModuleRevisionId() + ": looked in " + resolveData.getNodeIds() + " and root module id was " + moduleDescriptor.getModuleRevisionId());
                        continue;
                    }
                    if (!ivyNode2.isEvicted(stringArray[i])) {
                        bl = false;
                        break;
                    }
                    if (!this.settings.debugConflictResolution()) continue;
                    Message.debug("caller " + ivyNode2.getId() + " of " + ivyNode.getId() + " is evicted");
                }
                if (bl) {
                    Message.verbose("all callers are evicted for " + ivyNode + ": evicting too");
                    ivyNode.markEvicted(stringArray[i], null, null, null);
                    continue;
                }
                if (!this.settings.debugConflictResolution()) continue;
                Message.debug(ivyNode.getId() + " isn't transitively evicted, at least one caller was not evicted");
            }
        }
    }

    private void fetchDependencies(VisitNode visitNode, String string, boolean bl) {
        Object object2;
        this.checkInterrupted();
        long l = System.currentTimeMillis();
        if (visitNode.getParent() != null) {
            Message.verbose("== resolving dependencies " + visitNode.getParent().getId() + "->" + visitNode.getId() + " [" + visitNode.getParentConf() + "->" + string + "]");
        } else {
            Message.verbose("== resolving dependencies for " + visitNode.getId() + " [" + string + "]");
        }
        ResolveData resolveData = visitNode.getNode().getData();
        VisitNode visitNode2 = resolveData.getCurrentVisitNode();
        resolveData.setCurrentVisitNode(visitNode);
        DependencyDescriptor dependencyDescriptor = visitNode.getDependencyDescriptor();
        VersionMatcher versionMatcher = visitNode.getNode().getData().getSettings().getVersionMatcher();
        if (!(dependencyDescriptor == null || visitNode.getRoot() == visitNode.getParent() && versionMatcher.isDynamic(dependencyDescriptor.getDependencyRevisionId()))) {
            this.resolveConflict(visitNode, string);
        }
        if (visitNode.loadData(string, bl)) {
            this.resolveConflict(visitNode, string);
            if (!visitNode.isEvicted() && !visitNode.isCircular()) {
                String[] stringArray = visitNode.getRealConfs(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.doFetchDependencies(visitNode, stringArray[i]);
                }
            }
        } else if (!(visitNode.hasProblem() || visitNode.isEvicted() || visitNode.isCircular())) {
            String[] stringArray = visitNode.getRealConfs(string);
            for (int i = 0; i < stringArray.length; ++i) {
                this.doFetchDependencies(visitNode, stringArray[i]);
            }
        }
        if (visitNode.isEvicted() && ((IvyNodeEviction.EvictionData)(object2 = visitNode.getEvictedData())).getSelected() != null) {
            for (Object object2 : ((IvyNodeEviction.EvictionData)object2).getSelected()) {
                if (!((IvyNode)object2).isLoaded()) {
                    ((IvyNode)object2).updateConfsToFetch(Collections.singleton(string));
                    continue;
                }
                this.fetchDependencies(visitNode.gotoNode((IvyNode)object2), string, true);
            }
        }
        if (this.settings.debugConflictResolution()) {
            Message.debug(visitNode.getId() + " => dependencies resolved in " + string + " (" + (System.currentTimeMillis() - l) + "ms)");
        }
        resolveData.setCurrentVisitNode(visitNode2);
    }

    private void doFetchDependencies(VisitNode visitNode, String string) {
        Object object = visitNode.getConfiguration(string);
        if (object == null) {
            if (!visitNode.isConfRequiredByMergedUsageOnly(string)) {
                Message.warn("configuration not found '" + string + "' in " + visitNode.getResolvedId() + ": ignoring");
                if (visitNode.getParent() != null) {
                    Message.warn("it was required from " + visitNode.getParent().getResolvedId());
                }
            }
            return;
        }
        boolean bl = false;
        if (visitNode.getRequestedConf() == null) {
            visitNode.setRequestedConf(string);
            bl = true;
        }
        if (((String[])(object = ((Configuration)object).getExtends())).length > 0) {
            visitNode.updateConfsToFetch(Arrays.asList(object));
        }
        for (int i = 0; i < ((String[])object).length; ++i) {
            this.fetchDependencies(visitNode, object[i], false);
        }
        if (!this.isDependenciesFetched(visitNode.getNode(), string) && visitNode.isTransitive()) {
            Object object2 = visitNode.getDependencies(string);
            object = object2.iterator();
            while (object.hasNext()) {
                int n;
                object2 = (VisitNode)object.next();
                ((VisitNode)object2).useRealNode();
                String[] stringArray = ((VisitNode)object2).getRequiredConfigurations(visitNode, string);
                for (n = 0; n < stringArray.length; ++n) {
                    this.fetchDependencies((VisitNode)object2, stringArray[n], true);
                }
                if (((VisitNode)object2).isEvicted() || ((VisitNode)object2).hasProblem()) continue;
                stringArray = ((VisitNode)object2).getConfsToFetch();
                for (n = 0; n < stringArray.length; ++n) {
                    this.fetchDependencies((VisitNode)object2, stringArray[n], false);
                }
            }
            this.markDependenciesFetched(visitNode.getNode(), string);
        }
        if (bl) {
            visitNode.setRequestedConf(null);
        }
    }

    private boolean isDependenciesFetched(IvyNode object, String string) {
        object = this.getDependenciesFetchedKey((IvyNode)object, string);
        return this.fetchedSet.contains(object);
    }

    private void markDependenciesFetched(IvyNode object, String string) {
        object = this.getDependenciesFetchedKey((IvyNode)object, string);
        this.fetchedSet.add(object);
    }

    private String getDependenciesFetchedKey(IvyNode object, String string) {
        object = ((IvyNode)object).getResolvedId();
        object = ((ModuleRevisionId)object).getOrganisation() + "|" + ((ModuleRevisionId)object).getName() + "|" + ((ModuleRevisionId)object).getRevision() + "|" + string;
        return object;
    }

    private void resolveConflict(VisitNode visitNode, String string) {
        VisitNode visitNode2 = visitNode;
        this.resolveConflict(visitNode2, visitNode2.getParent(), string, Collections.EMPTY_SET);
    }

    private boolean resolveConflict(VisitNode visitNode, VisitNode visitNode2, String string, Collection object) {
        Collection collection;
        Object object22;
        Object object3;
        Object object4;
        boolean bl;
        while (true) {
            if (visitNode2 == null || visitNode == visitNode2) {
                return true;
            }
            if (this.checkConflictSolvedEvicted(visitNode, visitNode2)) {
                return true;
            }
            bl = this.settings.debugConflictResolution();
            if (this.checkConflictSolvedSelected(visitNode, visitNode2)) {
                if (this.resolveConflict(visitNode, visitNode2.getParent(), string, (Collection)object)) {
                    VisitNode visitNode3 = visitNode;
                    object4 = visitNode3.getEvictionDataInRoot(visitNode3.getRootModuleConf(), visitNode2);
                    if (object4 != null) {
                        if (bl) {
                            Message.debug(visitNode + " was previously evicted in root module conf " + visitNode.getRootModuleConf());
                        }
                        visitNode.markEvicted((IvyNodeEviction.EvictionData)object4);
                        if (bl) {
                            Message.debug("evicting " + visitNode + " by " + object4);
                        }
                    }
                    return true;
                }
                return false;
            }
            object4 = visitNode2.getNode().getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf());
            object4.addAll(visitNode2.getNode().getPendingConflicts(visitNode.getRootModuleConf(), visitNode.getModuleId()));
            object3 = this.computeConflicts(visitNode, visitNode2, string, (Collection)object, (Collection)object4);
            object22 = visitNode2.getNode().getConflictManager(visitNode.getModuleId());
            collection = this.resolveConflicts(visitNode, visitNode2, (Collection)object3, (ConflictManager)object22);
            if (collection == null) {
                if (bl) {
                    Message.debug("impossible to resolve conflicts for " + visitNode + " in " + visitNode2 + " yet");
                    Message.debug("setting all nodes as pending conflicts for later conflict resolution: " + object3);
                }
                visitNode2.getNode().setPendingConflicts(visitNode.getModuleId(), visitNode.getRootModuleConf(), (Collection)object3);
                return false;
            }
            if (bl) {
                Message.debug("selected revisions for " + visitNode + " in " + visitNode2 + ": " + collection);
            }
            if (!collection.contains(visitNode.getNode())) break;
            object = object4;
            object.removeAll(collection);
            object4 = object.iterator();
            while (object4.hasNext()) {
                object3 = (IvyNode)object4.next();
                ((IvyNode)object3).markEvicted(visitNode.getRootModuleConf(), visitNode2.getNode(), (ConflictManager)object22, collection);
                if (!bl) continue;
                Message.debug("evicting " + object3 + " by " + ((IvyNode)object3).getEvictedData(visitNode.getRootModuleConf()));
            }
            visitNode2.getNode().setResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), collection);
            object4 = new HashSet<IvyNode>(visitNode2.getNode().getEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()));
            object4.removeAll(collection);
            object4.addAll(object);
            visitNode2.getNode().setEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), (Collection)object4);
            visitNode2.getNode().setPendingConflicts(visitNode.getModuleId(), visitNode.getRootModuleConf(), Collections.EMPTY_SET);
            visitNode2 = visitNode2.getParent();
        }
        if (collection.isEmpty() && bl) {
            Message.verbose("conflict manager '" + object22 + "' evicted all revisions among " + object3);
        }
        object4 = new HashSet(visitNode2.getNode().getEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()));
        object.removeAll(collection);
        object4.removeAll(collection);
        object4.addAll(object);
        object4.add(visitNode.getNode());
        visitNode2.getNode().setEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), (Collection)object4);
        visitNode2.getNode().setPendingConflicts(visitNode.getModuleId(), visitNode.getRootModuleConf(), Collections.EMPTY_SET);
        visitNode.markEvicted(visitNode2, (ConflictManager)object22, collection);
        if (bl) {
            Message.debug("evicting " + visitNode + " by " + visitNode.getEvictedData());
        }
        object3 = visitNode2.getNode().getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf());
        bl = true;
        if (!object3.equals(collection)) {
            visitNode2.getNode().setResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), collection);
            for (Object object22 : collection) {
                if (object3.contains(object22)) continue;
                bl &= this.resolveConflict(visitNode.gotoNode((IvyNode)object22), visitNode2.getParent(), string, (Collection)object);
            }
        }
        return bl;
    }

    private Collection resolveConflicts(VisitNode visitNode, VisitNode visitNode2, Collection collection, ConflictManager conflictManager) {
        if (visitNode.getParent() != visitNode2 && conflictManager == this.settings.getConflictManager(visitNode.getModuleId()) && visitNode.getParent().getNode().getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()).equals(collection)) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("no new conflicting revisions for " + visitNode + " in " + visitNode2 + ": " + collection);
            }
            return collection;
        }
        if (this.settings.debugConflictResolution()) {
            Message.debug("found conflicting revisions for " + visitNode + " in " + visitNode2 + ": " + collection);
        }
        return conflictManager.resolveConflicts(visitNode2.getNode(), collection);
    }

    private Collection computeConflicts(VisitNode visitNode, VisitNode object, String object2, Collection collection, Collection collection2) {
        object2 = new LinkedHashSet<IvyNode>();
        object2.add(visitNode.getNode());
        boolean bl = collection2.removeAll(collection);
        if (bl || collection2.isEmpty() && !visitNode.getParent().getNode().equals(((VisitNode)object).getNode())) {
            object = ((VisitNode)object).getNode().getDependencies(visitNode.getRootModuleConf(), ((VisitNode)object).getNode().getConfigurations(visitNode.getRootModuleConf()), ((VisitNode)object).getRequestedConf());
            object = object.iterator();
            while (object.hasNext()) {
                IvyNode ivyNode = (IvyNode)object.next();
                if (ivyNode.getModuleId().equals(visitNode.getModuleId())) {
                    object2.add(ivyNode);
                }
                object2.addAll(ivyNode.getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()));
            }
        } else if (collection2.isEmpty()) {
            object = visitNode.getParent();
            object = ((VisitNode)object).getNode().getDependencies(visitNode.getRootModuleConf(), ((VisitNode)object).getNode().getConfigurations(visitNode.getRootModuleConf()), ((VisitNode)object).getRequestedConf());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (IvyNode)iterator.next();
                if (!((IvyNode)object).getModuleId().equals(visitNode.getModuleId())) continue;
                object2.add(object);
            }
        } else {
            object2.addAll(collection2);
        }
        return object2;
    }

    private boolean checkConflictSolvedSelected(VisitNode visitNode, VisitNode visitNode2) {
        if (visitNode2.getResolvedRevisions(visitNode.getModuleId()).contains(visitNode.getResolvedId())) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("conflict resolution already done for " + visitNode + " in " + visitNode2);
            }
            return true;
        }
        return false;
    }

    private boolean checkConflictSolvedEvicted(VisitNode visitNode, VisitNode visitNode2) {
        if (visitNode2.getEvictedRevisions(visitNode.getModuleId()).contains(visitNode.getResolvedId())) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("conflict resolution already done for " + visitNode + " in " + visitNode2);
            }
            return true;
        }
        return false;
    }

    public DependencyDescriptor mediate(DependencyDescriptor dependencyDescriptor, ResolveOptions object) {
        if (dependencyDescriptor == null) {
            return null;
        }
        Object object2 = object = ((ResolveOptions)object).getResolveMode() == null ? this.settings.getResolveMode(dependencyDescriptor.getDependencyId()) : ((ResolveOptions)object).getResolveMode();
        if ("dynamic".equals(object) && !dependencyDescriptor.getDynamicConstraintDependencyRevisionId().equals(dependencyDescriptor.getDependencyRevisionId())) {
            DependencyDescriptor dependencyDescriptor2 = dependencyDescriptor;
            return dependencyDescriptor2.clone(ModuleRevisionId.newInstance(dependencyDescriptor2.getDynamicConstraintDependencyRevisionId(), dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getRevision()));
        }
        return dependencyDescriptor;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public ResolveEngineSettings getSettings() {
        return this.settings;
    }

    public SortEngine getSortEngine() {
        return this.sortEngine;
    }

    private void checkInterrupted() {
        IvyContext.getContext().getIvy().checkInterrupted();
    }
}

