/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Color;
import java.util.Locale;

public final class ColorHelper {
    private ColorHelper() {
    }

    public static Color html2color(String html) {
        if (!html.isEmpty() && html.charAt(0) == '#') {
            html = html.substring(1);
        }
        if (html.length() == 3) {
            return ColorHelper.html2color(new String(new char[]{html.charAt(0), html.charAt(0), html.charAt(1), html.charAt(1), html.charAt(2), html.charAt(2)}));
        }
        if (html.length() != 6 && html.length() != 8) {
            return null;
        }
        try {
            return new Color(Integer.parseInt(html.substring(0, 2), 16), Integer.parseInt(html.substring(2, 4), 16), Integer.parseInt(html.substring(4, 6), 16), html.length() == 8 ? Integer.parseInt(html.substring(6, 8), 16) : 255);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String int2hex(int i) {
        String s = Integer.toHexString(i / 16) + Integer.toHexString(i % 16);
        return s.toUpperCase(Locale.ENGLISH);
    }

    public static String color2html(Color col) {
        return ColorHelper.color2html(col, true);
    }

    public static String color2html(Color col, boolean withAlpha) {
        int alpha;
        if (col == null) {
            return null;
        }
        String code = '#' + ColorHelper.int2hex(col.getRed()) + ColorHelper.int2hex(col.getGreen()) + ColorHelper.int2hex(col.getBlue());
        if (withAlpha && (alpha = col.getAlpha()) < 255) {
            code = code + ColorHelper.int2hex(alpha);
        }
        return code;
    }

    public static Color getForegroundColor(Color bg) {
        return bg == null ? null : ((double)bg.getRed() * 0.299 + (double)bg.getGreen() * 0.587 + (double)bg.getBlue() * 0.114 > 186.0 ? Color.BLACK : Color.WHITE);
    }
}

