/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import org.parosproxy.paros.core.scanner.Plugin;
import org.zaproxy.zap.utils.Stats;

public class PluginStats {
    private final String pluginName;
    private final int pluginId;
    private long startTime;
    private long totalTime;
    private int messageCount;
    private int alertCount;
    private int progress;
    private boolean skipped;
    private String skippedReason;

    PluginStats(Plugin plugin) {
        this.pluginName = plugin.getName() == null ? "" : plugin.getName();
        this.pluginId = plugin.getId();
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    void skip() {
        this.skipped = true;
        Stats.incCounter("stats.ascan." + this.pluginId + ".skipped");
    }

    void setSkippedReason(String reason) {
        this.skippedReason = reason;
    }

    public String getSkippedReason() {
        return this.skippedReason;
    }

    void start() {
        this.startTime = System.currentTimeMillis();
        Stats.incCounter("stats.ascan." + this.pluginId + ".started");
    }

    void stopped() {
        this.totalTime = System.currentTimeMillis() - this.startTime;
        Stats.incCounter("stats.ascan." + this.pluginId + ".time", this.totalTime);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTotalTime() {
        if (this.totalTime == 0L && this.startTime > 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.totalTime;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    void incMessageCount() {
        ++this.messageCount;
        Stats.incCounter("stats.ascan.urls");
        Stats.incCounter("stats.ascan." + this.pluginId + ".urls");
    }

    public int getAlertCount() {
        return this.alertCount;
    }

    void incAlertCount() {
        ++this.alertCount;
        Stats.incCounter("stats.ascan." + this.pluginId + ".alerts");
    }

    public int getProgress() {
        return this.progress;
    }

    void incProgress() {
        ++this.progress;
    }

    void setProgress(int progress) {
        this.progress = progress;
    }
}

